# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Early Rounds (2-3): Tit-for-Tat with 20% chance of unprovoked defection
    if 2 <= current_round <= 3:
        if random.random() < 0.2:
            return "D"
        else:
            return opp_history[-1]
    
    # Middle Rounds (4-7): Switch to "D" if opponent defected at least once in Rounds 2-3
    if 4 <= current_round <= 7:
        early_defects = opp_history[1:3].count("D")  # Rounds 2-3 (0-based index 1-2)
        if early_defects >= 1:
            return "D"
        else:
            if random.random() < 0.3:
                return "D"
            else:
                return opp_history[-1]
    
    # Late Rounds (8-10): Defect in last two rounds if opponent mostly cooperated
    if 8 <= current_round <= 10:
        total_cooperations = opp_history.count("C")
        total_defections = len(opp_history) - total_cooperations
        if total_cooperations > total_defections and current_round >= 9:
            return "D"
        else:
            return opp_history[-1]
    
    # Default fallback (shouldn't reach here)
    return "C"